#include "common.h"

Color::Color(float r = 1.0f, float g = 1.0f, float b = 1.0f, float alpha = 1.0f) : r(r), g(g), b(b), alpha(alpha) {}

Text::Text(
	bool isDisplayed = false,
	std::string text = "",
	const Color& color = Color(0.0, 0.0, 0.0, 1.0)
) : isDisplayed(isDisplayed), text(text), color(color) {}

void Text::display(int x = 0, int y = 0) {
	if(!isDisplayed || text.empty()){
		return;
	}
	
	void* font = GLUT_BITMAP_HELVETICA_18;
	int textWidth = 0;
	for(char c : text) {
		textWidth += glutBitmapWidth(font, c);
	}

	int textHeight = 18;

	float offsetX = 0;
	float offsetY = 0;
	
	glColor4f(color.r, color.g, color.b, color.alpha);
	glRasterPos2f(x + offsetX - textWidth / 2, y + offsetY - textHeight / 2);

	for (char c : text) {
		glutBitmapCharacter(font, c);
	}
}

Panel::Panel(
	bool isDisplayed = true,
	bool isActive = true,
	int x = 0,
	int y = 0,
	int w = 100,
	int h = 100,
	const Color& fill = Color(1.0, 1.0, 1.0, 1.0),
	const Color& stroke = Color(0.0, 0.0, 0.0, 1.0),
	const Text& text = Text(),
	const std::function<void(void)> clicked = []() {}
) : isDisplayed(isDisplayed), isActive(isActive), x(x), y(y), w(w), h(h), fill(fill), stroke(stroke), text(text), clicked(clicked) {}

void Panel::display(int offsetX = 0, int offsetY = 0) {
	if (isDisplayed) {
		int dx = offsetX + x;
		int dy = offsetY + y;

		glColor4f(fill.r, fill.g, fill.b, fill.alpha);
		glBegin(GL_QUADS);
		glVertex2f(dx, dy);
		glVertex2f(dx + w, dy);
		glVertex2f(dx + w, dy + h);
		glVertex2f(dx, dy + h);
		glEnd();

		glColor4f(stroke.r, stroke.g, stroke.b, stroke.alpha);
		glBegin(GL_LINE_LOOP);
		glVertex2f(dx, dy);
		glVertex2f(dx + w, dy);
		glVertex2f(dx + w, dy + h);
		glVertex2f(dx, dy + h);
		glEnd();

		text.display(dx + w / 2, dy + h / 2);

		for(int i = 0; i < childs.size(); i ++) {
			childs[i].display(dx, dy);
		}
	}
}

bool Panel::handleMouseClick(int mx, int my, int offsetX, int offsetY) {
		if(!isDisplayed || !isActive){
			return false;
		}
		
		int dx = offsetX + x;
		int dy = offsetY + y;
		for(int i = (int)childs.size() - 1; i >= 0; i --) {
			if(childs[i].handleMouseClick(mx, my, dx, dy)) {
				return true;
			}
		}
		if(mx >= dx && mx <= dx + w && my >= dy && my <= dy + h) {
			if(clicked) {
				clicked();
			}
			return true;
		}
		return false;
}

UI::UI(bool isDisplayed = true, bool isActive = true) : isDisplayed(isDisplayed), isActive(isActive) {}

void UI::display() {
	if(isDisplayed) {
		glDisable(GL_DEPTH_TEST);
		for(int i = 0; i < childs.size(); i ++) {
			childs[i].display(0, 0);
		}
		glEnable(GL_DEPTH_TEST);
	}
}

bool UI::handleMouseClick(int mx, int my) {
	if(!isDisplayed || !isActive) {
		return false;
	}

	for(int i = (int)childs.size() - 1; i >= 0; i --) {
		if(childs[i].handleMouseClick(mx, my, 0, 0)) {
			return true;
		}
	}
	return false;
}
