#ifndef MATH_H
#define MATH_H

class Angle;

class Vector {
	public:
	float x, y, z;
	Vector(float x = 0, float y = 0, float z = 0) : x(x), y(y), z(z) {}
	
	float abs() const {
		return sqrt(x*x + y*y + z*z);
	}
	
	Vector unit() const {
		float len = abs();
		if (len == 0){
			return Vector(0,0,0);
		}
		return Vector(x / len, y / len, z / len);
	}
	
	Angle arg();

	Vector operator=(const Vector& v) {
		x = v.x;
		y = v.y;
		z = v.z;
		return *this;
	}
	
	Vector operator+(const Vector& v) const {
		return Vector(x + v.x, y + v.y, z + v.z);
	}
	
	Vector operator-(const Vector& v) const {
		return Vector(x - v.x, y - v.y, z - v.z);
	}
	
	Vector operator*(float s) const {
		return Vector(x * s, y * s, z * s);
	}
};

class Angle {
public:
	float pol;
	float azi;
	
	Angle(float p = 0, float a = 0){
		pol = fmod(p + PI / 2, PI) - PI / 2;
		azi = fmod(a + PI, 2 * PI) - PI;
	}

	Angle operator+(const Angle& ang) const {
		return Angle(pol + ang.pol, azi + ang.azi);
	}

	Vector coo(float radius) const {
		float pr = pol;
		float ar = azi;
		float x = radius * cos(pr) * sin(ar);
		float y = radius * sin(pr);
		float z = -radius * cos(pr) * cos(ar);
		return Vector(x,y,z);
	}
};

inline Angle Vector::arg() {
	float r = abs();
	if (r == 0){
		return Angle(0,0);
	}
	float p = asin(y/r);
	float a = atan2(x, -z);
	return Angle(p,a);
}

#endif