#ifndef PLAYER_H
#define PLAYER_H

class Box {
public:
	Vector min, max;
	
	Box(Vector min, Vector);
	
	Box move(float x, float y, float z);
	Vector center();
	bool intersects(const Box& other);
};

class Player {
public:
	Vector pos;
	Vector vel;
	Vector insideVel;
	Vector outsideVel;
	Angle camera;
	float moveSpeed;
	bool isFlying;
	bool isGrounded;
	Box hitbox;
	int handBlockId;
	
	Player();

	void walk(Keyboard &keyboard);
	bool checkCollision(Vector p, World &world);
	void update(World &world);
};

#endif