#ifndef WORLD_H
#define WORLD_H

class World;
class Player;

class Chunk {
public:
	int blocks[CHUNK_SIZE][CHUNK_SIZE][CHUNK_SIZE];
	GLuint listId;
	bool needsUpdate;
	int cx, cy, cz;

	Chunk();
	~Chunk();

	void init(int x, int y, int z);
	bool shouldRenderFace(World& world, int gx, int gy, int gz);
	void updateDisplayList(World& world, GLuint terrainAtlasID);
	void display();
};

struct BMPPalette {
	unsigned char data[256][4];
};

class World {
public:
	int width, height, depth;
	Chunk* chunks[WORLD_CHUNKS_X][WORLD_CHUNKS_Y][WORLD_CHUNKS_Z];
	BlockRegistry blockRegistry;
	BMPPalette palette;
	bool hasPalette = false;
	
	World(int& nowSlotNumber, GLuint& terrainAtlasID);
	~World();
	
	int getBlock(int x, int y, int z);
	void setBlock(int x, int y, int z, int id);
	void display(GLuint terrainAtlasID);
	bool loadFromBMP(const char* path);
	bool saveToBMP(const char* path);
	void createDefaultPalette();
};

struct RaycastResult {
	bool hit;
	int x, y, z;
	int faceX, faceY, faceZ;
};

RaycastResult raycast(Player player, World& world, float maxDist);

void pixelToWorld(int u, int v, int& x, int& y, int& z);

#endif