#ifndef UI_H
#define UI_H

class Color {
public:
	float r, g, b, alpha;
	
	Color(float r, float g, float b, float alpha);
};

class Text {
public:
	bool isDisplayed;
	std::string text;
	Color color;

	Text(
		bool isDisplayed,
		std::string text,
		const Color& color
	);

	void display(int x, int y);
};

class Panel {
public:
	bool isDisplayed;
	bool isActive;
	int x, y, w, h;
	Color fill, stroke;
	Text text;
	std::vector<Panel> childs;
	std::function<void(void)> clicked;

	Panel(
		bool isDisplayed,
		bool isActive,
		int x,
		int y,
		int w,
		int h,
		const Color& fill,
		const Color& stroke,
		const Text& text,
		const std::function<void(void)> clicked
	);

	void display(int offsetX, int offsetY);

	bool handleMouseClick(int mx, int my, int offsetX, int offsetY);
};

class UI {
public:
	bool isDisplayed;
	bool isActive;
	std::vector<Panel> childs;

	UI(bool isDisplayed, bool isActive);

	void display();

	bool handleMouseClick(int mx, int my);
};

#endif