#ifndef BLOCK_H
#define BLOCK_H

struct RawImageData {
	unsigned char* data;
	int width;
	int height;
};

struct UVRect {
	float u1, v1, u2, v2;
};

class Skin {
public:
	UVRect top, side, bottom;

	Skin(
		int dtype,
		UVRect t,
		UVRect s,
		UVRect b
	);
};

class Block {
public:
	bool isCollidable;
	bool isDisplayed;
	bool isOpaque;
	std::string name;
	Skin skin;

	Block(
		const std::string& name,
		const Skin& skin,
		bool isCollidable,
		bool isDisplayed,
		bool isOpaque
	);
};

class BlockRegistry {
public:
	std::vector<Block> blocks;

	BlockRegistry(int& nowSlotNumber, GLuint& terrainAtlasID);

	Block* get(int id);
};

RawImageData loadBMPRaw(const char* filename);

UVRect getUV(int slotX, int slotY);

void initTextureAtlas(GLuint& terrainAtlasID);
UVRect addFileToAtlas(const char* filename, int slotX, int slotY);

#endif
