#include "common.h"

Key::Key() : pressed(false) {}
void Key::keyPressed() {
	pressed = true;
}
	
void Key::keyReleased() {
	pressed = false;
}

Keyboard::Keyboard() : keys(512) {
	for(int i = 0; i < 512; i ++) {
		keys[i] = Key();
	}
}

void Keyboard::keyPressed(unsigned int key) {
	if(key < keys.size()) {
		keys[key].keyPressed();
	}
}

void Keyboard::keyReleased(unsigned int key) {
	if(key < keys.size()) {
		keys[key].keyReleased();
	}
}

Key& Keyboard::getKey(unsigned int key) {
	static Key dummyKey;
	if(key < keys.size()) {
		return keys[(unsigned int)key];
	}
	return dummyKey;
}

Mouse::Mouse() {
	lastMouseX = 0;
	lastMouseY = 0;
	warp = false;
	firstMouse = true;
	mousePointer = true;
}

void Mouse::updateMouseState(){
	if (mousePointer) {
		glutSetCursor(GLUT_CURSOR_INHERIT);
	} else {
		glutSetCursor(GLUT_CURSOR_NONE);
		firstMouse = true;
	}
}