#define __MAIN__
#include "common.h"

GLuint terrainAtlasID;
int nowSlotNumber = 0;

UI gameUI = UI(true, true);
UI inventoryUI = UI(false, false);
UI menuUI = UI(false, false);
UI titleUI = UI(true, true);

Keyboard keyboard = Keyboard();
Mouse mouse = Mouse();

World* world = nullptr;

int inventoryPage = 0;
Player player = Player();

void UIInit() {
	gameUI.childs.emplace_back(
		true,
		false,
		0,
		0,
		800,
		600,
		Color(0.0, 0.0, 0.0, 0.0),
		Color(1.0, 1.0, 1.0, 0.0),
		Text(
			true,
			"+",
			Color(0.0, 0.0, 0.0, 0.75)
		),
		[]() {}
	);
	menuUI.childs.emplace_back(
		true,
		true,
		100,
		100,
		600,
		400,
		Color(0.0, 0.0, 0.0, 0.5),
		Color(1.0, 1.0, 1.0, 1.0),
		Text(
			false,
			"",
			Color(0.0, 0.0, 0.0, 0.0)
		),
		[]() {}
	);

	menuUI.childs.emplace_back(
		true,
		true,
		300,
		300,
		200,
		100,
		Color(1.0, 0.0, 0.0, 0.25),
		Color(1.0, 1.0, 1.0, 0.0),
		Text(
			true,
			"Return to Title",
			Color(1.0, 1.0, 0.0, 1.0)
		),
		[]() {
			titleUI.isDisplayed = true;
			titleUI.isActive = true;
			menuUI.isDisplayed = false;
			menuUI.isActive = false;
			mouse.mousePointer = true;
			mouse.updateMouseState();
		}
	);

	menuUI.childs.emplace_back(
		true,
		true,
		300,
		150,
		200,
		100,
		Color(1.0, 0.0, 0.0, 0.25),
		Color(1.0, 1.0, 1.0, 0.0),
		Text(
			true,
			"Save this World",
			Color(1.0, 1.0, 0.0, 1.0)
		),
		[]() {
			if(world->saveToBMP("map.bmp")) {
				std::cout << "World saved successfully!" << std::endl;
			} else {
				std::cout << "Failed to save the world." << std::endl;
			}
		}
	);

	titleUI.childs.emplace_back(
		true,
		true,
		0,
		0,
		800,
		600,
		Color(0.0, 0.0, 0.0, 1.0),
		Color(1.0, 1.0, 1.0, 0.0),
		Text(
			false,
			"",
			Color(0.0, 0.0, 0.0, 0.0)
		),
		[]() {}
	);
	titleUI.childs.emplace_back(
		true,
		true,
		300,
		450,
		200,
		100,
		Color(0.0, 0.0, 0.0, 0.0),
		Color(1.0, 1.0, 1.0, 0.0),
		Text(
			true,
			"FineCraft",
			Color(1.0, 0.0, 1.0, 1.0)
		),
		[](){}
	);
	titleUI.childs.emplace_back(
		true,
		true,
		300,
		300,
		200,
		100,
		Color(1.0, 1.0, 1.0, 1.0),
		Color(1.0, 1.0, 1.0, 1.0),
		Text(
			true,
			"Start",
			Color(1.0, 0.0, 1.0, 1.0)
		),
		[]() {
			titleUI.isDisplayed = false;
			titleUI.isActive = false;
			mouse.mousePointer = false;
			mouse.updateMouseState();
		}
	);
	titleUI.childs.emplace_back(
		true,
		true,
		300,
		100,
		200,
		100,
		Color(1.0, 1.0, 1.0, 1.0),
		Color(1.0, 1.0, 1.0, 1.0),
		Text(
			true,
			"End",
			Color(1.0, 0.0, 1.0, 1.0)
		),
		[]() {
			exit(0);
		}
	);
}

void buildInventoryUI() {
	inventoryUI.childs.clear();

	Panel bg(
		true,
		true,
		50,
		50,
		350,
		500,
		Color(0.0, 0.0, 0.0, 0.7),
		Color(1.0, 1.0, 1.0, 1.0),
		Text(
			false,
			"",
			Color(0.0, 0.0, 0.0, 0.0)
		),
		[]() {}
	);

	int totalBlocks = world->blockRegistry.blocks.size() - 1;
	int maxPage = (totalBlocks - 1) / ITEMS_PER_PAGE;

	int startIndex = inventoryPage * ITEMS_PER_PAGE + 1;
	int endIndex   = std::min(startIndex + ITEMS_PER_PAGE, totalBlocks + 1);

	int y = 390;
	int itemH = 40;
	
	for (int i = startIndex; i < endIndex; i ++) {
		Block& block = world->blockRegistry.blocks[i];
		if (!block.isDisplayed) continue;

		Panel item(
			true,
			true,
			10,
			y,
			330,
			itemH,
			Color(0.2, 0.2, 0.2, 0.8),
			Color(1.0, 1.0, 1.0, 1.0),
			Text(
				true,
				block.name,
				Color(1.0, 1.0, 1.0, 1.0)
			),
			[i]() {
				player.handBlockId = i;
				buildInventoryUI();
			}
		);

		bg.childs.push_back(item);
		y -= itemH + 5;
	}
	
	Panel handBlock(
		true,
		true,
		10,
		440,
		330,
		50,
		Color(0.0, 0.0, 0.0, 0.5),
		Color(1.0, 1.0, 1.0, 1.0),
		Text(true, world->blockRegistry.blocks[player.handBlockId].name, Color(1.0, 1.0, 0.0, 1.0)),
		[]() {}
	);
	
	Panel leftBtn(
		true, 
		inventoryPage > 0,
		10,
		10,
		60,
		30,
		Color(0.3, 0.3, 0.3, 0.8),
		Color(1,1,1,1),
		Text(true, "<", Color(1,1,1,1)),
		[]() {
			if (inventoryPage > 0) {
				inventoryPage --;
				buildInventoryUI();
			}
		}
	);

	Panel rightBtn(
		true, inventoryPage < maxPage,
		280,
		10,
		60,
		30,
		Color(0.3, 0.3, 0.3, 0.8),
		Color(1,1,1,1),
		Text(true, ">", Color(1,1,1,1)),
		[maxPage]() {
			if (inventoryPage < maxPage) {
				inventoryPage ++;
				buildInventoryUI();
			}
		}
	);

	Panel pageText(
		true,
		false,
		120,
		10,
		100,
		30,
		Color(0, 0, 0, 0),
		Color(0, 0, 0, 0),
		Text(
			true,
			std::to_string(inventoryPage + 1) + " / " + std::to_string(maxPage + 1),
			Color(1,1,1,1)
		),
		[]() {}
	);

	bg.childs.push_back(handBlock);
	bg.childs.push_back(leftBtn);
	bg.childs.push_back(rightBtn);
	bg.childs.push_back(pageText);

	inventoryUI.childs.push_back(bg);
}

void display() {
	glClearColor(0.53f, 0.81f, 0.92f, 1.0f);
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	gluPerspective(
		60.0,
		(double)SCREEN_WIDTH / (double)SCREEN_HEIGHT,
		0.1,
		1000.0
	);
	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();

	if(!titleUI.isDisplayed) {
		gluLookAt(
			player.pos.x,
			player.pos.y + 1.5f,
			player.pos.z,
			player.pos.x + player.camera.coo(1).x,
			player.pos.y + 1.5f + player.camera.coo(1).y,
			player.pos.z + player.camera.coo(1).z,
			0, 1, 0
		);
		
		glEnable(GL_DEPTH_TEST);
		glEnable(GL_TEXTURE_2D);
		world->display(terrainAtlasID);
		glDisable(GL_TEXTURE_2D);

		RaycastResult res = raycast(player, *world, 5.0);
		if (res.hit) {
			glPushMatrix();
			glTranslatef(res.x + 0.5f, res.y + 0.5f, res.z + 0.5f);
			glColor3f(0, 0, 0);
			glutWireCube(1.02);
			glPopMatrix();
		}
	}
	
	glMatrixMode(GL_PROJECTION);
	glPushMatrix();
	glLoadIdentity();
	gluOrtho2D(0, SCREEN_WIDTH, 0, SCREEN_HEIGHT);

	glMatrixMode(GL_MODELVIEW);
	glPushMatrix();
	glLoadIdentity();

	glDisable(GL_DEPTH_TEST);
	glEnable(GL_BLEND);
	glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);

	if (!titleUI.isDisplayed) {
		gameUI.display();
		inventoryUI.display();
		menuUI.display();
	} else {
		titleUI.display();
	}

	glDisable(GL_BLEND);
	glEnable(GL_DEPTH_TEST);

	glPopMatrix();
	glMatrixMode(GL_PROJECTION);
	glPopMatrix();
	glMatrixMode(GL_MODELVIEW);

	glutSwapBuffers();
}

void idle(){
	if(!titleUI.isDisplayed) {
		player.walk(keyboard);
		player.update(*world);
	}
	glutPostRedisplay();
}

void reshape(int w, int h) {
    if (w != SCREEN_WIDTH || h != SCREEN_HEIGHT) {
        glutReshapeWindow(SCREEN_WIDTH, SCREEN_HEIGHT);
    }
    glViewport(0, 0, SCREEN_WIDTH, SCREEN_HEIGHT);
}

void keyboardFunc(unsigned char key, int x, int y) {
	int tempKey = key;
	if(key >= 'a' - 'a' + 1 && key < 'z' - 'a' + 1) {
		tempKey = key + 'a' - 1;
	}
	if(key >= 'A' && key < 'Z' + 1) {
		tempKey = key - 'A' + 'a';
	}
	
	keyboard.keyPressed(tempKey);
	switch(key) {
		case 'e' - 'a' + 1:
		case 'e':
		case 'E':
			if(!titleUI.isDisplayed) {
				if(!menuUI.isDisplayed) {
					if(!inventoryUI.isDisplayed) {
						buildInventoryUI();
					}
					inventoryUI.isDisplayed = !inventoryUI.isDisplayed;
					inventoryUI.isActive = inventoryUI.isDisplayed;
				}
				mouse.mousePointer = inventoryUI.isDisplayed;
				mouse.updateMouseState();
			}
			break;
		case 'q' - 'a' + 1:
		case 'q':
		case 'Q':
		player.isFlying = !player.isFlying;
			break;
		case 27:
			if(!titleUI.isDisplayed) {
				mouse.mousePointer = false;
				if(!inventoryUI.isDisplayed) {
					menuUI.isDisplayed = !menuUI.isDisplayed;
					menuUI.isActive = menuUI.isDisplayed;
					mouse.mousePointer = menuUI.isDisplayed;
				}
				inventoryUI.isDisplayed = false;
				inventoryUI.isActive = false;
				mouse.updateMouseState();
			}
			break;
	}
	glutPostRedisplay();
}


void keyboardUpFunc(unsigned char key, int x, int y) {
	int tempKey = key;
	if(key >= 'a' - 'a' + 1 && key < 'z' - 'a' + 1) {
		tempKey = key + 'a' - 1;
	}
	if(key >= 'A' && key < 'Z' + 1) {
		tempKey = key - 'A' + 'a';
	}
	keyboard.keyReleased(tempKey);
	glutPostRedisplay();
}


void specialFunc(int key, int x, int y) {
	keyboard.keyPressed(key + 256);
		
	glutPostRedisplay();
}


void specialUpFunc(int key, int x, int y) {
	keyboard.keyReleased(key + 256);
	glutPostRedisplay();
}

void mouseMove(int x, int y) {
	if (mouse.mousePointer) {
		return;
	}

	if (mouse.warp) {
		mouse.warp = false;
		return;
	}
	
	if (mouse.firstMouse) {
		mouse.lastMouseX = x;
		mouse.lastMouseY = y;
		mouse.firstMouse = false;
	}
	
	float xoffset = x - mouse.lastMouseX;
	float yoffset = mouse.lastMouseY - y;
	mouse.lastMouseX = x;
	mouse.lastMouseY = y;
	float sensitivity = 0.1f;
	xoffset *= sensitivity;
	yoffset *= sensitivity;
	player.camera.azi += xoffset / 180.0f * PI;
	player.camera.azi = fmod(player.camera.azi + PI, 2 * PI) - PI;
	player.camera.pol += yoffset / 180.0f * PI;
	float limit = PI / 2 - 0.01f;
	if (player.camera.pol > limit) player.camera.pol = limit;
	if (player.camera.pol < -limit) player.camera.pol = -limit;
	int cx = SCREEN_WIDTH / 2;
	int cy = SCREEN_HEIGHT / 2;
	mouse.warp = true;
	glutWarpPointer(cx, cy);
	mouse.lastMouseX = cx;
	mouse.lastMouseY = cy;
}

void mouseClick(int button, int state, int x, int y) {
	if (!mouse.mousePointer) {
		int uiX = x;
		int uiY = SCREEN_HEIGHT - y;

		if (state == GLUT_DOWN) {
			bool uiHandled = false;
			if (titleUI.isDisplayed) {
				uiHandled = titleUI.handleMouseClick(uiX, uiY);
			} else {
				if (menuUI.isDisplayed) uiHandled = menuUI.handleMouseClick(uiX, uiY);
				if (!uiHandled && inventoryUI.isDisplayed) uiHandled = inventoryUI.handleMouseClick(uiX, uiY);
				if (!uiHandled && gameUI.isDisplayed) uiHandled = gameUI.handleMouseClick(uiX, uiY);
			}
			if (uiHandled) {
				glutPostRedisplay();
				return;
			}

			RaycastResult res = raycast(player, *world, 5.0);
			if(res.hit) {
				if(button == GLUT_RIGHT_BUTTON) {
					if(world->blockRegistry.get(player.handBlockId)->isCollidable) {
						Box blockBox(Vector(res.faceX, res.faceY, res.faceZ), Vector(res.faceX + 1, res.faceY + 1, res.faceZ + 1));
						if(player.hitbox.move(player.pos.x, player.pos.y, player.pos.z).intersects(blockBox)) {
							return;
						}
					}
					world->setBlock(res.faceX, res.faceY, res.faceZ, player.handBlockId);
				} else if(button == GLUT_LEFT_BUTTON) {
					world->setBlock(res.x, res.y, res.z, 0);
				}
			}
		}
	} else {
		int uiX = x;
		int uiY = SCREEN_HEIGHT - y;
		if (state == GLUT_DOWN && button == GLUT_LEFT_BUTTON) {
			if (menuUI.isDisplayed && menuUI.handleMouseClick(uiX, uiY)) return;
			if (inventoryUI.isDisplayed && inventoryUI.handleMouseClick(uiX, uiY)) return;
			if (titleUI.isDisplayed && titleUI.handleMouseClick(uiX, uiY)) return;
		}
	}
}

int main(int argc,char**argv){
	UIInit();
	glutInit(&argc,argv);
	glutInitDisplayMode(GLUT_RGBA | GLUT_DOUBLE | GLUT_DEPTH);
	glutInitWindowSize(SCREEN_WIDTH, SCREEN_HEIGHT);
	glutCreateWindow("FineCraft");
	mouse.updateMouseState();
	world = new World(nowSlotNumber, terrainAtlasID);
	if(world->loadFromBMP("map.bmp")) {
		std::cout << "Load successful!!" << std::endl;
	} else {
		std::cout << "Load failed... Generating new world." << std::endl;
		for(int i = 0; i < WORLD_CHUNKS_X * CHUNK_SIZE; i ++) {
			for(int j = 0; j < WORLD_CHUNKS_Z * CHUNK_SIZE; j ++) {
				world->setBlock(i, 0, j, 1);
				for(int k = 1; k < WORLD_CHUNKS_Y * CHUNK_SIZE; k ++) {
					world->setBlock(i, k, j, 0);
				}
			}
		}
	}
	buildInventoryUI();
	glEnable(GL_DEPTH_TEST);
	glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);
	glutDisplayFunc(display);
	glutIdleFunc(idle);

	glutReshapeFunc(reshape);

	glutIgnoreKeyRepeat(GL_TRUE);
	
	glutKeyboardFunc(keyboardFunc);
	glutSpecialFunc(specialFunc);
	glutKeyboardUpFunc(keyboardUpFunc);
	glutSpecialUpFunc(specialUpFunc);
	glutPassiveMotionFunc(mouseMove);
	glutMouseFunc(mouseClick);
	glutMainLoop();
	return 0;
}